%Declaration of Using Parameter%
%AnnotationFStyle of Naming@(Function)_(Name of Parameter)%

%Maximum Value of Each Data(Physical)[Unit depends on each data](MAX)
MAX_trq_MG2_tgt = 200;
MAX_w_ROT_MG2 = 2000;
MAX_v_MG2_Inverter_DC = 400;
MAX_MG2_Power_factor = 1;
MAX_k_radps2Volt_MG2_tgt = 2;
MAX_I_MG2_tgt = 500;

%Maximum Value of Each Data(Digital)[-](Dmax)
Dmax_trq_MG2_tgt = 65536;
Dmax_w_ROT_MG2 = 524288;
Dmax_v_MG2_Inverter_DC = 65536;
Dmax_MG2_Power_factor = 256;
Dmax_k_radps2Volt_MG2_tgt = 512;
Dmax_I_MG2_tgt = 131072;

%Minimum Value of Each Data(Physical)[Unit depends on each data](MIN)
MIN_trq_MG2_tgt = -200;
MIN_w_ROT_MG2 = -2000;
MIN_v_MG2_Inverter_DC = 0;
MIN_MG2_Power_factor = 0;
MIN_k_radps2Volt_MG2_tgt = 0;
MIN_I_MG2_tgt = -500;

%Minimum Value of Each Data(Digital)[-](Dmin)
Dmin_trq_MG2_tgt = 0;
Dmin_w_ROT_MG2 = -524288;
Dmin_v_MG2_Inverter_DC = 0;
Dmin_MG2_Power_factor = 0;
Dmin_k_radps2Volt_MG2_tgt = 0;
Dmin_I_MG2_tgt = -131072;

%Data Offset(Physical)[Unit depends on each data](Offset)
Offset_trq_MG2_tgt = 200;
Offset_w_ROT_MG2 = 0;
Offset_v_MG2_Inverter_DC = 0;
Offset_MG2_Power_factor = 0;
Offset_k_radps2Volt_MG2_tgt = 0;
Offset_I_MG2_tgt = 0;

%Data Offset(Digital)[-](Doffset)
Doffset_trq_MG2_tgt = 32768;
Doffset_w_ROT_MG2 = 0;
Doffset_v_MG2_Inverter_DC = 0;
Doffset_MG2_Power_factor = 0;
Doffset_k_radps2Volt_MG2_tgt = 0;
Doffset_I_MG2_tgt = 0;

%Data Resolution[-](Res)
Res_trq_MG2_tgt= 400/65536;
Res_w_ROT_MG2 = 4000/1048576;
Res_v_MG2_Inverter_DC = 400/65536;
Res_MG2_Power_factor = 1/256;
Res_k_radps2Volt_MG2_tgt = 2/256;
Res_I_MG2_tgt = 1000/262144;

%Data Length[bit]iDLj
DL_trq_MG2_tgt = 16;
DL_w_ROT_MG2 = 21;
DL_v_MG2_Inverter_DC = 16;
DL_MG2_Power_factor = 8;
DL_k_radps2Volt_MG2_tgt = 8;
DL_I_MG2_tgt = 19;

%Signed or Unsigned[Signed:1,Unsigned:0](SG)
SG_trq_MG2_tgt = 0;
SG_w_ROT_MG2 = 1;
SG_v_MG2_Inverter_DC = 0;
SG_MG2_Power_factor = 0;
SG_k_radps2Volt_MG2_tgt = 0;
SG_I_MG2_tgt = 1;

%Byte Order[0:Big,1:Little]iBOj
BO_trq_MG2_tgt = 0;
BO_w_ROT_MG2 = 1;
BO_v_MG2_Inverter_DC = 1;
BO_MG2_Power_factor = 0;
BO_k_radps2Volt_MG2_tgt = 0;
BO_I_MG2_tgt = 0;

%Communication Duration[ms]iCDj
CD_trq_MG2_tgt = 10;
CD_w_ROT_MG2 = 10;
CD_v_MG2_Inverter_DC = 10;
CD_MG2_Power_factor = 10;
CD_k_radps2Volt_MG2_tgt = 10;
CD_I_MG2_tgt = 10;

%Data Start Position[bit]iDPj
DP_trq_MG2_tgt = 7;
DP_w_ROT_MG2 = 16;
DP_v_MG2_Inverter_DC = 37;
DP_MG2_Power_factor = 63;
DP_k_radps2Volt_MG2_tgt = 7;
DP_I_MG2_tgt = 15;

%CAN Data Field Length[byte]iDFj
DF_TX_CAN = 8;
DF_RX_CAN = 4;

%CAN Format Bit Setting[bit](-)
CAN_DLC = 4;
CAN_ID = 11;

%CAN_ID Setting[-](ID)
ID_P2S = 26;
ID_S2P = 27;
